import axios from 'axios';

// Crear una instancia de Axios con la base URL configurada
const apiClient = axios.create({
  baseURL: process.env.NODE_ENV === 'production' ? 'https://fame-fdac.iot-catalogue.com' : '',
  headers: {
    'Content-Type': 'application/json',
    'accept': 'application/json',
    'Authorization': 'Bearer FlIsbBwtJFrBzNUzrQz01_fgPvnJ-2K4EdzlloiBukg'
  }
});

export default class ApiService {
  /**
   * Perform a query to the backend API to search for data.
   *
   * @param {Object} data - The data to be sent in the query
   * @returns {Promise<Object>} - A promise that resolves with the data from the response
   * @throws {Error} - If an error occurs during the query
   */
  static async query(data) {
    try {
      const url = '/api/data/search';
      const headers = apiClient.defaults.headers; // Corregido aquí

      // Log the request details
      console.log('Making request to:', apiClient.defaults.baseURL + url);
      console.log('Request headers:', headers);
      console.log('Request payload:', data);

      // Realiza una solicitud POST al endpoint '/api/data/search' con los datos proporcionados
      const response = await apiClient.post(url, data); // Corregido aquí
      
      // Log the response data
      console.log('Response data:', response.data);

      // Retorna los datos de la respuesta
      return response.data.results;
    } catch (error) {
      // Registra el error y vuelve a lanzarlo
      console.error("Error fetching data:", error);
      throw error;
    }
  }
}
