import {defineStore} from "pinia";
import ApiService from "@/services/ApiService";

export const useApiStore = defineStore("api", {
  state: () => ({
    response: null,
    loading: false,
    total: null,
  }),
  actions: {

    /**
     * Queries the API with the provided data.
     * @param {Object} data - The data to query the API with.
     */
    async query(data) {
      try {
        // Set loading state to true
        this.loading = true;

        // Fetch the monthly events using the ApiService
        this.response = await ApiService.query(data);
        this.total = this.response.length;

        // Set loading state back to false
        this.loading = false;

      } catch (error) {
        // Log any errors that occur during the fetch
        console.error("Error:", error);
      }
    },
    /**
     * Cleans the response by setting it to null.
     * If an error occurs during the process, logs the error.
     */
    cleanResponse() {
      try {
        // Set the response to null
        this.response = null;
      } catch (error) {
        // Log any errors that occur during the process
        console.error("Error:", error);
      }
    },
  },
});
