declare namespace NodeJS {
  interface ProcessEnv {
    /**
     * RPC endpoint for the blockchain node (e.g. Besu, Hardhat, Geth)
     */
    BLOCKCHAIN_RPC_URL: string;

    /**
     * Address of the TradingManagement contract (used for expiration checks)
     */
    TRADING_MANAGEMENT_ADDRESS: string;

    /**
     * Validation method used for access verification: 'ON_CHAIN' or 'OFF_CHAIN'
     */
    VALIDATION_METHOD: 'ON_CHAIN' | 'OFF_CHAIN';

    /**
     * Base URL of the off-chain Data Access API (used when VALIDATION_METHOD is OFF_CHAIN)
     */
    DATA_ACCESS_API: string;

    /**
     * Address of the Subscription ERC-1155 token contract
     */
    SUB_ADDRESS: string;

    /**
     * Address of the Pay-As-You-Go ERC-1155 token contract
     */
    PAYG_ADDRESS: string;

    /**
     * Address of the Pay-As-You-Use ERC-1155 token contract
     */
    PAYU_ADDRES: string;
  }
}
