import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { AccessEvaluatorModule } from './modules/access-evaluator/access-evaluator.module';
import { BlockchainGatewayModule } from './modules/blockchain-gateway/blockchain-gateway.module';
import { configValidationSchema } from './config/validation';
import { AccessEvaluatorController } from './modules/access-evaluator/access-evaluator.controller';
import { PaymentTokenProcessorModule } from './modules/redeem-data-access/payment-token-processor.module';
import { PaymentTokenProcessorController } from './modules/redeem-data-access/payment-token-processor.controller';

@Module({
  imports: [
    ConfigModule.forRoot({
      isGlobal: true,
      validationSchema: configValidationSchema,
    }),
    AccessEvaluatorModule,
    PaymentTokenProcessorModule,
    BlockchainGatewayModule,
  ],
  controllers: [AccessEvaluatorController, PaymentTokenProcessorController],
})
export class AppModule {}
