import { ApiProperty } from '@nestjs/swagger';
import { IsEthereumAddress, IsNotEmpty, IsNumberString } from 'class-validator';

// Enums
export enum TokenType {
  SUB = 'SUB',
  PAYG = 'PAYG',
  PAYU = 'PAYU',
}

export class WithdrawFundsDto {
  @ApiProperty({
    description: 'Customer Ethereum address to withdraw funds from',
    example: '0xf2d72bf781c11186553884574c01175c7d205822',
  })
  @IsEthereumAddress()
  @IsNotEmpty()
  customerAddress!: string;

  @ApiProperty({
    description: 'Amount to be withdrawn (in token units)',
    example: '1000',
  })
  @IsNotEmpty()
  @IsNumberString({}, { message: 'amount must be a valid number string' })
  amount!: string;
}
