import { ApiProperty } from '@nestjs/swagger';
import { IsString } from 'class-validator';

export class ValidateSignatureDto {
  @ApiProperty({
    description:
      'The message that was originally signed, usually in the format "tokenId:address:type".',
    example: '123...:0xabc...:SUB',
  })
  @IsString()
  message!: string;

  @ApiProperty({
    description: 'The ECDSA signature of the message, signed by the user.',
    example: '0xabcdef123456...',
  })
  @IsString()
  signature!: string;

  @ApiProperty({
    description:
      'The Ethereum address expected to have produced the signature.',
    example: '0xabc123...',
  })
  @IsString()
  expectedAddress!: string;
}
