import { keccak256, toUtf8Bytes } from 'ethers/lib/utils';
import { BigNumber } from 'ethers';

/**
 * Mimics Solidity's uint256(keccak256(abi.encodePacked(str)))
 */
export function getIDHash(str: string): string {
  const hash = keccak256(toUtf8Bytes(str));
  return BigNumber.from(hash).toString();
}
