import { INestApplication } from '@nestjs/common';
import { DocumentBuilder, SwaggerModule } from '@nestjs/swagger';
import * as fs from 'fs';

export const initSwagger = (app: INestApplication): INestApplication => {
  const customCss = `
.swagger-ui .topbar { display: none }
.swagger-ui .info .title { text-transform: capitalize }
`;

  // eslint-disable-next-line @typescript-eslint/no-var-requires
  const packageJson = require('../package.json');

  const options = new DocumentBuilder()
  .setTitle('Data Gate API')
  .setDescription(
    'API for validating access to data using blockchain and off-chain logic',
  )
  .setVersion('1.0')
  .addBearerAuth()
    .setVersion(packageJson.version)
    .addBearerAuth();

  const document = SwaggerModule.createDocument(app, options.build());

  fs.writeFileSync(
    'swagger-specification.data-gate.json',
    JSON.stringify(document),
  );
  SwaggerModule.setup('swagger', app, document, {
    customCss,
    customCssUrl:
      'https://cdn.jsdelivr.net/npm/swagger-ui-themes@3.0.0/themes/3.x/theme-flattop.css',
  });
  return app;
};
