import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { configValidationSchema } from './config/validation';
import { RedeemDataAccessModule } from './modules/redeem-data-access/redeem-data-access.module';
import { RedeemDataAccessController } from './modules/redeem-data-access/redeem-data-access.controller';

@Module({
  imports: [
    ConfigModule.forRoot({
      isGlobal: true,
      validationSchema: configValidationSchema,
    }),
    RedeemDataAccessModule,
  ],
  controllers: [RedeemDataAccessController],
})
export class AppModule {}
