import { ApiProperty } from '@nestjs/swagger';
import {
  IsEnum,
  IsEthereumAddress,
  IsNotEmpty,
  IsString,
} from 'class-validator';

export class ValidateRequestDto {
  @ApiProperty({
    description: 'Unique token ID associated with the asset or license',
  })
  @IsString()
  @IsNotEmpty()
  tokenId!: string;

  @ApiProperty({
    description: 'Customer Ethereum address used to sign the request',
  })
  @IsEthereumAddress()
  @IsNotEmpty()
  senderAddress!: string;

  @ApiProperty({
    enum: ['SUB', 'PAYG', 'PAYU'],
    description: 'Token model type: SUB, PAYG, or PAYU',
  })
  @IsEnum(['SUB', 'PAYG', 'PAYU'], {
    message: `tokenType must be one of: 'SUB', 'PAYG', 'PAYU'`,
  })
  @IsNotEmpty()
  tokenType!: 'SUB' | 'PAYG' | 'PAYU';

  @ApiProperty({ description: 'Signed message used to authenticate' })
  @IsString()
  @IsNotEmpty()
  signature!: string;
}
