/**
 * TokenUsageService
 *
 * Service for registering and querying token usage.
 * Uses mock in-memory storage (mock-usage-store.ts) for tracking usage.
 *
 * NOTE: This is a temporary mock implementation — replace with persistent storage in production.
 */

import { Injectable, Logger } from '@nestjs/common';
import { addUsage, getUsagesByAddress, UsageRecord } from './mock-usage-store';

@Injectable()
export class TokenUsageService {
  private readonly logger = new Logger(TokenUsageService.name);

  registerUsage(
    tokenId: string,
    sender: string,
    tokenType: 'PAYU' | 'SUB' | 'PAYG',
    volumeInKB?: string,
  ) {
    if (tokenType === 'PAYG' && !volumeInKB) {
      throw new Error('PAYU token must include volumeInKB');
    }

    const record: UsageRecord =
      tokenType === 'PAYG'
        ? {
            tokenId,
            sender,
            tokenType,
            timestamp: Date.now(),
            volumeInKB: volumeInKB!,
          }
        : { tokenId, sender, tokenType, timestamp: Date.now() };

    addUsage(record);
    this.logger.log(`Token usage recorded: ${JSON.stringify(record)}`);
    this.logger.debug(this.getUsageFor(sender));
  }

  getUsageFor(sender: string) {
    return getUsagesByAddress(sender);
  }
}
