import { Module } from '@nestjs/common';
import { RedeemDataAccessService } from './redeem-data-access.service';
import { HttpModule } from '@nestjs/axios';
import { TokenUsageService } from './mock-token-usage.service';

// Provides access validation logic, depends on blockchain and policy modules
@Module({
  imports: [HttpModule],
  providers: [RedeemDataAccessService, TokenUsageService],
  exports: [RedeemDataAccessService, TokenUsageService],
})
export class RedeemDataAccessModule {}
