import { NestFactory } from '@nestjs/core';
import { AppModule } from './app.module';
import { ValidationPipe } from '@nestjs/common';
import { initSwagger } from './swagger-setup';
import { AppConfig, GlobalExceptionFilter } from '@api-shared';
import * as dotenv from 'dotenv';

const envFile = process.env.NODE_ENV ? `.env.${process.env.NODE_ENV}` : '.env';
console.log(`Loading env file: ${envFile}`);
dotenv.config({ path: envFile, override: true });

new AppConfig();

async function bootstrap() {
  const app = await NestFactory.create(AppModule);

  app.useGlobalPipes(new ValidationPipe({ whitelist: true, transform: true }));
  app.setGlobalPrefix('');
  app.useGlobalFilters(new GlobalExceptionFilter());
  initSwagger(app);

  const port = 3000;

  await app.listen(port);
  console.log(`Application is listening on port ${port}`);
}
bootstrap();
