import {
  Controller,
  Get,
  Query,
  UseInterceptors,
  Logger,
} from '@nestjs/common';
import { ApiOperation, ApiTags, ApiResponse, ApiQuery } from '@nestjs/swagger';
import {
  ListClearedItemsDto,
  DataAccessService,
  LoggerInterceptor,
} from '@api-shared';

@UseInterceptors(LoggerInterceptor)
@Controller('tm/v1.0')
@ApiTags('Data Access - private API')
export class DataAccessInternalController {
  constructor(private readonly dataAccessService: DataAccessService) {}

  logger = new Logger(DataAccessInternalController.name);

  @Get('list-cleared-items')
  @ApiOperation({
    summary:
      'Returns the list of access tokens indexes that are owned by the passed trading account. Returned indexes form Offering token that correspond with Data Access Token should be the same',
  })
  @ApiQuery({
    name: 'tradingAccount',
    description: 'The trading account to list cleared items for',
    required: true,
  })
  @ApiResponse({
    status: 200,
    description: 'Cleared items listed successfully',
  })
  @ApiResponse({ status: 500, description: 'Failed to list cleared items' })
  async listClearedItems(@Query() dto: ListClearedItemsDto): Promise<string[]> {
    return this.dataAccessService.listClearedItems(dto.tradingAccount);
  }
}
