import { Test, TestingModule } from '@nestjs/testing';
import { DataAccessPublicController } from '../../../../../libs/api-shared/src/modules/data-access/data-access-public.controller';
import { DataAccessService } from '../../../../../libs/api-shared/src/modules/data-access/data-access.service';
import { DataAccessSharedModule } from '../../../../../libs/api-shared/src/modules/data-access/data-access.module';
import { INestApplication } from '@nestjs/common';
import { AddressValidatorService, CommonUtils } from '@api-shared';

describe('DataAccessService (e2e)', () => {
  let app: INestApplication;

  beforeAll(async () => {
    const moduleFixture: TestingModule = await Test.createTestingModule({
      imports: [DataAccessSharedModule],
      controllers: [DataAccessPublicController],
      providers: [DataAccessService, CommonUtils, AddressValidatorService],
    }).compile();

    app = moduleFixture.createNestApplication();
    await app.init();
  });

  afterAll(async () => {
    await app.close();
  });

  it('Service is successfully constructed!', async () => {});
});
