import {
  Controller,
  HttpException,
  HttpStatus,
  UseInterceptors,
  Get,
} from '@nestjs/common';
import { OfferingService } from '@api-shared';
import { ApiOperation, ApiTags } from '@nestjs/swagger';
import { LoggerInterceptor } from '@api-shared';

@UseInterceptors(LoggerInterceptor)
@Controller('test-only/offering')
@ApiTags('Testing (deprecated - for test purposes only)')
export class OfferingTestController {
  constructor(private readonly offeringService: OfferingService) {}

  @Get('get-all-added-offerings')
  @ApiOperation({
    summary:
      'FOR TESTING ONLY -  Returns a list of all added offerings up to this point',
  })
  async getMintedTokens(): Promise<number[]> {
    try {
      const mintedTokens: number[] =
        await this.offeringService.getMintedTokens();
      return mintedTokens;
    } catch (error) {
      throw new HttpException('Getting asset URI error', HttpStatus.NOT_FOUND);
    }
  }
}
