import { Module } from '@nestjs/common';
import { DataAccessModule } from './modules/data-access/data-access.module';
import { PaymentModule } from './modules/payment/payment.module';
import { ContractInfoModule } from './modules/contract-info/contract-info.module';
import { TradingHistoryModule } from './modules/trading-history/trading-history.module';
import { PurchasesModule } from './modules/purchase/purchases.module';
import { ServeStaticModule } from '@nestjs/serve-static';
import { join } from 'path';

@Module({
  imports: [
    DataAccessModule,
    PaymentModule,
    ContractInfoModule,
    TradingHistoryModule,
    PurchasesModule,
    ServeStaticModule.forRoot({
      rootPath: join(__dirname, '..', '..', '..', 'apps/tm-public/src/assets'),
      serveRoot: '/assets',
    }),
  ],
})
export class AppModule {}
