import { NestFactory, Reflector } from '@nestjs/core';
import { AppModule } from './app.module';
import { ValidationPipe } from '@nestjs/common';
import { initSwagger } from './swagger-setup';
import { AppConfig, GlobalExceptionFilter } from '@api-shared';
import * as dotenv from 'dotenv';
import { AuthGuard, AuthService } from './guards/auth.guard';

const envFile = process.env.NODE_ENV ? `.env.${process.env.NODE_ENV}` : '.env';
console.log(`Loading env file: ${envFile}`);
dotenv.config({ path: envFile, override: true });

new AppConfig();

async function bootstrap() {
  const app = await NestFactory.create(AppModule);

  //TODO enable authentication on all routes when "salt" is accessible
  app.useGlobalGuards(new AuthGuard(new AuthService(), new Reflector()));
  app.useGlobalPipes(new ValidationPipe({ whitelist: true, transform: true }));
  app.setGlobalPrefix('api/v1.0');
  app.useGlobalFilters(new GlobalExceptionFilter());
  initSwagger(app);
  app.enableCors({
    origin: '*',
    methods: 'GET,HEAD,PUT,PATCH,POST,DELETE',
    preflightContinue: false,
    optionsSuccessStatus: 204,
  });

  const port = 3001;

  await app.listen(port);
  console.log(`Application is listening on port ${port}`);
}
bootstrap();
