import {
  Controller,
  Post,
  Body,
  UseInterceptors,
  Logger,
} from '@nestjs/common';
import {
  LoggerInterceptor,
  DataAccessService,
  PurchaseAccessRightDto,
} from '@api-shared';
import {
  ApiOperation,
  ApiTags,
  ApiResponse,
  ApiBody,
  ApiOkResponse,
  ApiBearerAuth,
} from '@nestjs/swagger';

@ApiBearerAuth()
@UseInterceptors(LoggerInterceptor)
@Controller('submissions')
@ApiTags('Data Access - public API')
export class DataAccessPublicController {
  constructor(private readonly dataAccessService: DataAccessService) {}

  logger = new Logger(DataAccessPublicController.name);

  @Post('/order')
  @ApiOperation({
    summary:
      'Generates an unsigned transaction for purchasing a Data Access Token (DAT). The user must sign and submit this transaction.',
  })
  @ApiBody({
    description: 'Purchase access right DTO',
    type: PurchaseAccessRightDto,
  })
  @ApiOkResponse({
    type: String,
  })
  @ApiResponse({
    status: 200,
    description: 'Purchasing order submitted successfully',
  })
  @ApiResponse({
    status: 500,
    description: 'Failed to submit purchasing order',
  })
  async submitPurchasingOrder(
    @Body() dto: PurchaseAccessRightDto,
  ): Promise<string> {
    return this.dataAccessService.purchaseAccessRight(dto.oid);
  }
}
