import {
  ApproveToSpendPaymentTokensDto,
  LoggerInterceptor,
  PaymentService,
} from '@api-shared';
import {
  Controller,
  HttpException,
  HttpStatus,
  Put,
  Query,
  UseInterceptors,
} from '@nestjs/common';
import { ApiOperation, ApiTags } from '@nestjs/swagger';
import { AllowUnauthorizedRequest } from '../../guards/allow-unathorized-request.decorator';

@UseInterceptors(LoggerInterceptor)
@Controller('payment')
@ApiTags('Payment Unsecure (Test Only - Remove in Production)')
export class PaymentTestController {
  constructor(private readonly paymentService: PaymentService) {}

  @AllowUnauthorizedRequest()
  @Put('approve-to-spend-payment-tokens')
  @ApiOperation({ summary: 'Approving operator to spend users Payment tokens' })
  async approveToSpend(
    @Query() dto: ApproveToSpendPaymentTokensDto,
  ): Promise<string> {
    try {
      const txHash: string =
        await this.paymentService.approveToSpendPaymentToken(
          dto.privateKey,
          dto.approveAmount,
        );
      return (
        `Approval for spending ${dto.approveAmount} amount of Payment succeeded! Transaction hash: ` +
        txHash
      );
    } catch (error) {
      throw new HttpException(
        'Failed to approve to spend Payment tokens',
        HttpStatus.INTERNAL_SERVER_ERROR,
      );
    }
  }
}
