import { Test, TestingModule } from '@nestjs/testing';
import { TradingHistoryController } from './trading-history.controller';
import {
  TradingHistoryService,
  TradingHistoryServiceMock,
  TradingHistorySharedModule,
} from '@api-shared';
import { INestApplication } from '@nestjs/common';

describe('TradingHistoryController (e2e)', () => {
  let app: INestApplication;

  beforeAll(async () => {
    const moduleFixture: TestingModule = await Test.createTestingModule({
      imports: [TradingHistorySharedModule],
      controllers: [TradingHistoryController],
      providers: [
        { provide: TradingHistoryService, useClass: TradingHistoryServiceMock },
      ],
    }).compile();

    app = moduleFixture.createNestApplication();
    await app.init();
  });

  afterAll(async () => {
    await app.close();
  });
});
