# Tests

This folder contains the automated tests for the project.

## Structure

- **src/private-e2e**: e2e tests of tm-private app.
- **src/public-e2e**: e2e tests of tm-public app.
- **src/user-flow**: e2e tests of tm-public app.
- **src/utils**: Setup and teardown helpers.

## Setup Environment for Tests

Before running tests, you need to start the local hardhat node and deploy contracts. It's recommended to use the test network for this purpose. Also, use `.env.test` file for the test environment configuration.

To runn all the tests from one command you can use:

```bash

npm run test:e2e
```

In separate terminal:
In project root:

```bash
npm run contracts:node:start:test
npm run contracts:compile
npm run contracts:deploy:test
```

## Running Tests

Ex:
In project root:

```bash
npm run tm-tests:flow
```

## Adding more tests

Setup of the project is dependent on NX project.json configuration.

To add another folders with test cases or suites you have to add config inside project.json:

Ex:

```json
        "your-test-name": {
          "testPathPattern": ["src/test-folder-name/.*\\.spec\\.ts$"]
        },
```

Then add "nx test tm-tests --configuration=your-test-name" in package.json

## Teardown

All app instances are autimatically closed.

// TODO, dedicate user accounts for specific test cases and randomize offer creation what will allow runnig tests without restarting the node.
For now hardhat node have to be restarted before every test.
