import request from 'supertest';
import { HttpStatus, INestApplication } from '@nestjs/common';
import { getPublicApp, getSigners } from '../utils/setup';
import { SignerWithAddress } from '@nomiclabs/hardhat-ethers/signers';

let signerWithAddress: SignerWithAddress[];
let app: INestApplication;

describe('data-access', () => {
  beforeAll(async () => {
    app = await getPublicApp();
    signerWithAddress = await getSigners();
  });

  it(`/GET /check-clearance - Check clearance endpoint works`, async () => {
    const response = await request(app.getHttpServer())
      .get('/data-access-info/check-clearance')
      .query({
        assetId: 1,
        addresses: [signerWithAddress[1].address],
        tokenType: 'SUB',
      });

    expect(response).toBeTruthy();
    expect(['false']).toContain(response.text);
    expect(response.statusCode).toBe(HttpStatus.OK);
  });

  it(`/GET /check-clearance - Check clearance returns error when fed with wrong data`, async () => {
    const response = await request(app.getHttpServer())
      .get('/data-access-info/check-clearance')
      .query({
        assetId: undefined,
        addresses: ['wrongAddress'],
        tokenType: 'SUB',
      });

    expect(response).toBeTruthy();
    expect(response.statusCode).toBe(HttpStatus.INTERNAL_SERVER_ERROR);
  });
});
