import axios from 'axios';

module.exports = async () => {
  // Take the initial snapshot after contract deployment
  const snapshotId = await takeSnapshot();
  console.log('Initial snapshot taken:', snapshotId);
  // Save the snapshot ID to the global scope (or in a temporary file)
  global.__SNAPSHOT_ID__ = snapshotId; // Save to global for later use in tests
};

// Function to take a snapshot of the current blockchain state
async function takeSnapshot(): Promise<string> {
  try {
    const response = await axios.post('http://127.0.0.1:8545', {
      jsonrpc: '2.0',
      method: 'evm_snapshot',
      params: [],
      id: 1,
    });
    console.log('Snapshot taken, ID:', response.data.result);
    return response.data.result; // Snapshot ID
  } catch (error) {
    console.error('Failed to take snapshot', error);
    throw error;
  }
}
