// Those two packages supply the types we need to
// build our custom reporter

// Our reporter implements only the onRunComplete lifecycle
// function, run after all tests have completed
module.exports = class CustomReporter {
  async onRunComplete(_, results) {
    const summary = `
  ====================================================
  Test Summary:
  Total Suites: ${results.numTotalTestSuites}
  Passed Suites: ${results.numPassedTestSuites}
  Failed Suites: ${results.numFailedTestSuites}
  Total Tests: ${results.numTotalTests}
  Passed Tests: ${results.numPassedTests}
  Failed Tests: ${results.numFailedTests}
  ====================================================
  `;

    console.log(summary);
  }
};
