import { Component } from '@angular/core';
import { MetaWalletService } from '../../services/metamask.service';
import { TmApiService } from '../../services/tm-api.service';

@Component({
  selector: 'app-approve-operator',
  standalone: true,
  templateUrl: './approve-operator.component.html',
})
export class AppApproveOperator {
  constructor(
    private metaWalletService: MetaWalletService,
    private tmApiService: TmApiService,
  ) {}
  approveOperator() {
    this.tmApiService.getApprovalTx().then((res) => {
      this.metaWalletService.signAndSentTransaction(res);
    });
    // this.metaWalletService.checkChainId();
    console.log('Approved Operator');
  }
}
