import { Component, EventEmitter, Input, Output } from '@angular/core';
import { CommonModule } from '@angular/common';
import { AccessData } from '../../../types/types';
import { AddressTrimPipe } from '../../../pipes/trim-address.pipe';

@Component({
  selector: 'app-data-access-card',
  standalone: true,
  imports: [CommonModule, AddressTrimPipe],
  template: `
    <div
      (click)="onExpand.emit(data)"
      class="bg-gray-800 rounded-lg shadow-lg p-6 hover:shadow-xl transition-shadow duration-300 border border-gray-700 cursor-pointer"
    >
      <div class="flex justify-between items-start gap-2">
        <h3 class="text-xl font-semibold mb-2 text-white">
          {{ data.assetName }}
        </h3>
        <span
          class="px-3 py-1 rounded-full text-sm shrink-0"
          [ngClass]="{
            'bg-blue-900 text-blue-200': data.tokenType === 'SUB',
            'bg-green-900 text-green-200': data.tokenType === 'PAYG',
            'bg-purple-900 text-purple-200': data.tokenType === 'PAYU'
          }"
        >
          {{ data.tokenType }}
        </span>
      </div>
      <p class="text-gray-300 mt-2">
        {{ data.assetDescription }}
      </p>
      <div class="mt-4 pt-4 border-t border-gray-600">
        <p class="text-sm text-gray-400">
          Offer ID: {{ data.offerId | addressTrim }}
        </p>
      </div>

      <div *ngIf="data.isExpanded" class="mt-4 pt-4 border-t border-gray-600">
        <div *ngIf="data.isLoadingToken" class="text-center p-2 text-gray-400">
          <p>Loading Validation Token...</p>
        </div>

        <div *ngIf="!data.isLoadingToken && data.tokenId">
          <button
            (click)="$event.stopPropagation(); onAccess.emit(data)"
            class="bg-blue-600 text-white px-4 py-2 rounded w-full font-semibold hover:bg-blue-700 transition-colors duration-300"
          >
            Access Data
          </button>
        </div>

        <div
          *ngIf="!data.isLoadingToken && !data.tokenId"
          class="text-center text-red-400 p-2"
        >
          <p>Could not retrieve validation token.</p>
        </div>
      </div>
    </div>
  `,
})
export class DataAccessCardComponent {
  @Input() data!: AccessData;

  /**
   * NEW: This event tells the parent component to expand this card and fetch the tokenId.
   */
  @Output() onExpand = new EventEmitter<AccessData>();

  /**
   * This event tells the parent that the user wants to proceed with validation.
   */
  @Output() onAccess = new EventEmitter<AccessData>();
}
