import { Component, OnInit } from '@angular/core';
import { MetaWalletService } from '../../services/metamask.service';
import { HttpClient } from '@angular/common/http';
import { GetChainIdReturnType } from 'viem';
import { environment } from '../../environments/environment';
import { AddressTrimPipe } from '../../pipes/trim-address.pipe';
import { CommonModule } from '@angular/common';

@Component({
  selector: 'app-metamask-connect',
  standalone: true,
  imports: [AddressTrimPipe, CommonModule],
  providers: [MetaWalletService, HttpClient],
  templateUrl: './metamask-connect.component.html',
})
export class AppMetamaskConnect implements OnInit {
  address: string | undefined;
  chain: GetChainIdReturnType | undefined;
  environment = environment;

  constructor(private metaWalletService: MetaWalletService) {}

  ngOnInit(): void {
    this.connect();
  }
  menuOpen = false; // Popup menu state

  toggleMenu() {
    this.menuOpen = !this.menuOpen;
  }

  connect() {
    return this.metaWalletService
      .checkChainId()
      .then(() => {
        return this.metaWalletService.getChain().then((chain) => {
          this.chain = chain;
        });
      })
      .then(() => {
        return this.metaWalletService.getAccount().then((res) => {
          this.address = res;
        });
      })
      .then(() => {
        console.log({
          address: this.address,
          chain: this.chain,
        });
      });
  }

  disconnect() {
    this.address = undefined;
    this.chain = undefined;
    this.menuOpen = false;
  }

  approveOperator() {
    return;
  }
}
