import { Component } from '@angular/core';
import { ReactiveFormsModule, FormGroup, FormControl } from '@angular/forms';
import { MetaWalletService } from '../../services/metamask.service';
import { TmApiService } from '../../services/tm-api.service';

@Component({
  selector: 'app-purchase-offer',
  standalone: true,
  imports: [ReactiveFormsModule],
  templateUrl: './purchase-offer.component.html',
})
export class PurchaseOfferComponent {
  form = new FormGroup({
    oid: new FormControl(''),
  });
  constructor(
    private metaWalletService: MetaWalletService,
    private tmApiService: TmApiService,
  ) {}

  onSubmit() {
    const payload = this.form.getRawValue();
    if (!payload.oid) {
      return;
    }

    this.tmApiService
      .getSubmissionOrderTx(payload.oid)
      .then((res) => {
        this.metaWalletService.signAndSentTransaction(res);
      })
      .catch(this.tmApiService.handleError);
  }
}
