import { Component } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { CommonModule } from '@angular/common';
import { AuthTokenService } from '../../services/auth-token.service';

@Component({
  selector: 'app-set-auth-token',
  standalone: true,
  templateUrl: './set-auth-token.component.html',
  imports: [CommonModule, FormsModule],
})
export class SetAuthToken {
  token: string = '';
  tokenSet: boolean = false;

  constructor(private authTokenService: AuthTokenService) {
    this.tokenSet = this.authTokenService.hasAuthToken();
  }

  setAuthToken() {
    if (this.token) {
      this.authTokenService.setAuthToken(this.token);
      this.tokenSet = true;
      // Optionally clear the input after setting
      this.token = '';
    }
  }

  clearToken() {
    this.authTokenService.removeAuthToken();
    this.tokenSet = false;
  }
}
