import { Component } from '@angular/core';
import { FormGroup, FormControl, ReactiveFormsModule } from '@angular/forms';
import { MetaWalletService } from '../../services/metamask.service';
import { HttpClient } from '@angular/common/http';
import { environment } from '../../environments/environment';
import { CommonModule } from '@angular/common';

import { firstValueFrom } from 'rxjs';

@Component({
  selector: 'app-token-access',
  standalone: true,
  imports: [ReactiveFormsModule, CommonModule],
  templateUrl: './token-access.component.html',
})
export class TokenAccessComponent {
  form = new FormGroup({
    tokenId: new FormControl(''),
    tokenType: new FormControl('SUB'),
  });

  result: any = null;

  constructor(
    private metaWalletService: MetaWalletService,
    private http: HttpClient,
  ) {}

  async onSubmit() {
    console.log('Submitting form...');

    const { tokenId, tokenType } = this.form.getRawValue();
    console.log('tokenId:', tokenId, 'tokenType:', tokenType);

    if (!tokenId || !tokenType) {
      console.warn('Form is incomplete');
      return;
    }

    try {
      console.log('Starting signing process...');
      const { address, message, signature } =
        await this.metaWalletService.signAccessMessage(
          tokenId,
          tokenType as 'SUB' | 'PAYG' | 'PAYU',
        );
      console.log('Signed!', { address, message, signature });

      const body = {
        tokenId,
        senderAddress: address,
        tokenType,
        signature,
      };

      console.log('Sending body to server:', body);

      this.result = await firstValueFrom(
        this.http.post<any>(
          `${environment.api.dataAccessApiService}/redeem-data-access`,
          body,
        ),
      );

      console.log('Validation response:', this.result);
    } catch (error: any) {
      console.error('Validation failed:', error);
      this.result = {
        error: error.message || 'Unauthorized access or validation failed.',
      };
    }
  }
}
