import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'addressTrim',
  standalone: true,
})
export class AddressTrimPipe implements PipeTransform {
  transform(address: string | undefined): string {
    if (!address) {
      return '';
    }
    return address ? `${address.slice(0, 6)}...${address.slice(-4)}` : '';
  }
}
