import { Injectable } from '@angular/core';

@Injectable({
  providedIn: 'root',
})
export class AuthTokenService {
  private readonly AUTH_TOKEN_KEY = 'authToken';

  constructor() {}

  /**
   * Sets the authentication token in localStorage
   * @param token The authentication token to store
   */
  setAuthToken(token: string): void {
    if (token) {
      localStorage.setItem(this.AUTH_TOKEN_KEY, token);
    }
  }

  /**
   * Gets the authentication token from localStorage
   * @returns The stored authentication token or null if not found
   */
  getAuthToken(): string | null {
    return localStorage.getItem(this.AUTH_TOKEN_KEY);
  }

  /**
   * Removes the authentication token from localStorage
   */
  removeAuthToken(): void {
    localStorage.removeItem(this.AUTH_TOKEN_KEY);
  }

  /**
   * Checks if an authentication token exists
   * @returns boolean indicating whether a token exists
   */
  hasAuthToken(): boolean {
    return this.getAuthToken() !== null;
  }
}
