import { HttpClient } from '@angular/common/http';
import { environment } from '../environments/environment';
import { Injectable } from '@angular/core';
import { firstValueFrom } from 'rxjs';
import { TokenType } from '../types/types';

export interface ValidateAccessReqDto {
  volumeInKB: number;
  tokenId: string;
  senderAddress: string;
  tokenType: TokenType;
  signature: string;
}

@Injectable({
  providedIn: 'root',
})
export class DataAccessServiceApiService {
  constructor(private httpClient: HttpClient) {}

  async validateAccess(payload: ValidateAccessReqDto) {
    return await firstValueFrom(
      this.httpClient.post<any>(
        `${environment.api.dataAccessApiService}/redeem-data-access`,
        payload,
      ),
    ).catch(this.handleError);
  }

  handleError(error: any): Promise<any> {
    console.error('An error occurred', error);
    let message = '';

    if (error.error.message) {
      message = error.error.message;
    } else if (error.message) {
      message = error.message;
    } else {
      message = JSON.stringify(error);
    }
    return Promise.reject(message);
  }
}
