export type TokenType = 'SUB' | 'PAYG' | 'PAYU';

// Define and export the AccessData interface
export interface AccessData {
  offerId: string;
  tokenType: TokenType;
  assetName: string;
  assetDescription: string;
  dataVolume?: number;

  // State Management Properties
  tokenId?: string;
  isExpanded?: boolean;
  isLoadingToken?: boolean;
}

// Your NewAccessCard interface can also live here
export interface NewAccessCard {
  offerId: string;
  tokenType: TokenType;
  assetName: string;
  assetDescription: string;
}
