const plugin = require('tailwindcss/plugin');

/** @type {import('tailwindcss').Config} */
module.exports = {
  content: ['./src/**/*.{html,ts}'],
  theme: {
    container: {
      center: true,
      padding: '10vw',
    },
    extend: {
      colors: {
        primary: '#1E40AF', // Custom primary color (blue-800)
        accent: '#F59E0B', // Custom accent color (amber-500)
        background: '#1A202C', // Default dark background
        foreground: '#F7FAFC', // Default light text
      },
      textColor: {
        DEFAULT: '#F7FAFC', // Default text color for dark mode
      },
      backgroundColor: {
        DEFAULT: '#1A202C', // Default background color for dark mode
      },
    },
  },
  plugins: [
    plugin(function ({ addComponents }) {
      addComponents({
        '.heading': {
          color: '#F7FAFC',
          fontWeight: '600',
          lineHeight: '1.25',
          marginBottom: '1rem',
        },
        '.heading-1': {
          '@apply heading': {},
          fontSize: '2.25rem', // text-4xl
          marginBottom: '1.5rem',
        },
        '.heading-2': {
          '@apply heading': {},
          fontSize: '1.875rem', // text-3xl
          marginBottom: '1.25rem',
        },
        '.heading-3': {
          '@apply heading': {},
          fontSize: '1.5rem', // text-2xl
          marginBottom: '1rem',
        },
        '.heading-4': {
          '@apply heading': {},
          fontSize: '1.25rem', // text-xl
          marginBottom: '0.75rem',
        },
        '.btn': {
          padding: '.5rem 1rem',
          borderRadius: '.25rem',
          fontWeight: '600',
        },
        '.btn-blue': {
          backgroundColor: '#3490dc',
          color: '#fff',
          '&:hover': {
            backgroundColor: '#2779bd',
          },
        },
        '.btn-red': {
          backgroundColor: '#e3342f',
          color: '#fff',
          '&:hover': {
            backgroundColor: '#cc1f1a',
          },
        },
      });
    }),
  ],
};
