# Upgradeability

```md
# Benefits of Upgradable Smart Contracts

Here is a list of a few benefits of upgradable smart contracts, which are as follows:

1. **Bug Fixes**: 
   - Due to its divided nature, it becomes easier for users to fix any bugs that arise after the deployment of smart contracts. This results in adaptability with increased efficiency and security of smart contracts.

2. **Future-Proofreading**: 
   - With updates, smart contracts can now be future-ready for all the enhancements and improvements in their functionality, resulting in adaptability and interaction of new features when required.

3. **Cost-Effective**: 
   - Instead of creating a new smart contract due to a bug that is not fixable, upgradable smart contracts allow for updates and modifications to the specific parts of the smart contract that developers wish to alter, thereby saving both time and resources.

4. **User Trust**: 
   - Users are more likely to trust a system that can be upgraded and maintained as needed. This guarantee can attract more users, aiding in the sustained prosperity of the app.

5. **Interoperability**: 
   - Upgradability enables compatibility with evolving standards and protocols, ensuring that the smart contract can seamlessly integrate with other systems and platforms.

6. **Long-Term Sustainability**: 
   - The ability to evolve and adapt over time enhances the longevity and sustainability of the application. Upgradable smart contracts can remain relevant and valuable in the ever-changing blockchain landscape.
```

## Diamond Upgradeability

[Diamond EIP-2535 Standard](https://eips.ethereum.org/EIPS/eip-2535)

##  Upgradeable Diamond vs. Centralized Private Database

Why have an upgradeable diamond instead of a centralized, private, mutable database?

1. Decentralized Autonomous Organizations (DAOs) and other governance systems can be used to upgrade diamonds.
2. Wide interaction and integration with the Ethereum ecosystem.
3. With open storage data and verified source code it is possible to show a provable history of trustworthiness.
4. With openness bad behavior can be spotted and reported when it happens.
5. Independent security and domain experts can review the change history of contracts and vouch for their history of trustworthiness.
6. It is possible for an upgradeable diamond to become immutable and trustless.


## Some Diamond Benefits

1. A stable contract address that provides needed functionality.
2. A single address with the functionality of multiple contracts (facets) that are independent from each other but can share internal functions, libraries, and state variables.
3. Emitting events from a single address can simplify event handling.
4. A way to add, replace, and remove multiple external functions atomically (in the same transaction).
5. Fine-grained upgrades, so you can change just the parts of a diamond that need to be changed.
6. Have greater control over when and what functions exist.
7. Decentralized Autonomous Organizations (DAOs), multisig contracts, and other governance systems can be used to upgrade diamonds.
8. An event that shows what functions are added, replaced, and removed.
9. The ability to show all changes made to a diamond.
10. Increase trust over time by showing all changes made to a diamond.
11. A way to look at a diamond to see its current facets and functions.
12. Have an immutable, trustless diamond.
13. Solves the 24KB maximum contract size limitation. Diamonds can be any size.
14. Separate functionality can be implemented in separate facets and used together in a diamond.
15. Diamonds can be created from already deployed, existing on-chain contracts.
16. Enables zero, partial, or full diamond immutability as desired, and when desired.
17. The ability to develop and improve an application over time with an upgradeable diamond and then make it immutable and trustless if desired.
18. Develop incrementally and let your diamond grow with your application.
19. Upgrade diamonds to fix bugs, add functionality, and implement new standards.
20. Organize your code with a diamond and facets.
21. Diamonds can be large (have many functions) but still be modular because they are compartmented with facets.
22. Contract architectures that call multiple contracts in a single transaction can save gas by condensing those contracts into a single diamond and accessing state variables directly.
23. Save gas by converting external functions to internal functions. This is done by sharing internal functions between facets.
24. Save gas by creating external functions for gas-optimized specific use cases, such as bulk transfers.
25. Diamonds are designed for tooling and user-interface software.


## Diamonds Downside

1. Diamonds are more complex than single contracts
   1.1 auditing and security reviews more challenging
   1.2. new developers need to learn how to work with diamonds
   1.3. more complex to test

## Bibliography

1. [Awesome Diamonds](https://github.com/mudgen/awesome-diamonds/blob/main/README.md)
2. [Upgradable Contracts Options](https://www.immunebytes.com/blog/what-are-upgradable-smart-contracts/)
3. [Transparent Proxy Pattern](https://medium.com/coinmonks/beginners-guide-to-transparent-proxy-pattern-f40d6085bf3c)
4. [HardHat Upgrade Plugins](https://docs.openzeppelin.com/upgrades-plugins/1.x/hardhat-upgrades)
5. [HardHat Upgrades API](https://docs.openzeppelin.com/upgrades-plugins/1.x/api-hardhat-upgrades)
6. [Tokens in Diamonds Example](https://hiddentao.com/archives/2023/08/08/building-multiple-nft-and-erc-20-tokens-backed-by-a-single-upgradeable-smart-contract)
7. [Diamonds Implementation Reference](https://github.com/mudgen/diamond?tab=readme-ov-file)
8. [Louper CLI - CLI for inspecting diamonds](https://github.com/mark3labs/louper-cli)
