#!/bin/bash

ENV_FILE=".env"
if [ ! -f "$ENV_FILE" ]; then
  ENV_FILE=".env.test"
  if [ ! -f "$ENV_FILE" ]; then
    echo "Neither .env nor .env.test file found!"
    return 1 
  fi
fi

echo "Using environment file: $ENV_FILE"

while IFS='=' read -r key value || [ -n "$key" ]; do
  if [[ -z "$key" || "$key" =~ ^\# ]]; then
    continue
  fi

  key=$(echo "$key" | xargs)
  value=$(echo "$value" | xargs)

  export "$key"="$value"
done < <(cat "$ENV_FILE"; echo)

echo $JWT_SECRET
echo "Environment variables from $ENV_FILE have been exported."



# docker build -t "manual" --build-arg BESU_RPC=$BESU_RPC --build-arg HARDHAT_NETWORK=$HARDHAT_NETWORK --build-arg PT_CONFIRM_OFFERING_ENDPOINT=$PT_CONFIRM_OFFERING_ENDPOINT -f devops/Dockerfile.private .