import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import { IsInt, IsOptional, IsString, Max, Min } from 'class-validator';
import { IPaginationOptions } from './pagination.model';

export class PaginationOptionsDto implements IPaginationOptions {
  @ApiProperty()
  @IsInt()
  @Max(100)
  @Min(2)
  @Type(() => Number)
  limit: number;

  @ApiProperty()
  @IsInt()
  @Type(() => Number)
  @Min(0)
  page: number;

  @ApiPropertyOptional()
  @IsOptional()
  route?: string;

  @ApiPropertyOptional()
  @IsOptional()
  @IsString()
  filters?: string;
}
