import { IPaginationLinks, IPaginationMeta } from './pagination.model';
import {
  ApiExtraModels,
  ApiProperty,
  ApiPropertyOptional,
} from '@nestjs/swagger';

@ApiExtraModels()
class PaginationLinksDto implements IPaginationLinks {
  @ApiPropertyOptional()
  first?: string;
  @ApiPropertyOptional()
  previous?: string;
  @ApiPropertyOptional()
  next?: string;
  @ApiPropertyOptional()
  last?: string;
}

@ApiExtraModels()
class PaginationMetaDto implements IPaginationMeta {
  @ApiProperty()
  itemCount: number;
  @ApiProperty()
  totalItems: number;
  @ApiProperty()
  itemsPerPage: number;
  @ApiProperty()
  totalPages: number;
  @ApiProperty()
  currentPage: number;
}

export class PaginationResponseDto<T> {
  @ApiProperty()
  data: T[];
  @ApiProperty()
  meta: PaginationMetaDto;
  @ApiPropertyOptional()
  links?: PaginationLinksDto;
}
