import {
  Controller,
  Post,
  Body,
  UseInterceptors,
  Logger,
} from '@nestjs/common';
import { DataAccessService } from './data-access.service';
import {
  ApiOperation,
  ApiTags,
  ApiResponse,
  ApiBody,
  ApiOkResponse,
} from '@nestjs/swagger';
import { PurchaseAccessRightDto } from './data-access-dto/data-access.dto';
import { LoggerInterceptor } from '../../interceptors';

@UseInterceptors(LoggerInterceptor)
@Controller('api/tm/v1.0')
@ApiTags('Data Access - public API')
export class DataAccessPublicController {
  constructor(private readonly dataAccessService: DataAccessService) {}

  logger = new Logger(DataAccessPublicController.name);

  @Post('submissions/order')
  @ApiOperation({
    summary:
      'Returns unsigned (ready to be signed in dashboard) transaction for submit purchasing order [Open API]',
  })
  @ApiBody({
    description: 'Purchase access right DTO',
    type: PurchaseAccessRightDto,
  })
  @ApiOkResponse({
    type: String,
  })
  @ApiResponse({
    status: 200,
    description: 'Purchasing order submitted successfully',
  })
  @ApiResponse({
    status: 500,
    description: 'Failed to submit purchasing order',
  })
  async submitPurchasingOrder(
    @Body() dto: PurchaseAccessRightDto,
  ): Promise<string> {
    return this.dataAccessService.purchaseAccessRight(dto.oid);
  }
}
