import { Test, TestingModule } from '@nestjs/testing';
import { DataAccessPublicController } from './data-access-public.controller';
import { DataAccessSharedModule } from './data-access.module';
import { INestApplication } from '@nestjs/common';
import * as request from 'supertest';

describe('DataAccessController (e2e)', () => {
  let app: INestApplication;

  beforeAll(async () => {
    const moduleFixture: TestingModule = await Test.createTestingModule({
      imports: [DataAccessSharedModule],
      controllers: [DataAccessPublicController],
      // providers: [
      //   { provide: DataAccessService, useClass: DataAccessServiceMock },
      // ],
    }).compile();

    app = moduleFixture.createNestApplication();
    await app.init();
  });

  afterAll(async () => {
    await app.close();
  });

  it('submisions/order (POST)', async () => {
    // const userName = 'Deployer';
    // const dataProvider = 'DataProvider';
    // const hasRight = true;
    const response = await request(app.getHttpServer()).post(
      addPrefix(`/submissions/order`),
      () => {
        return;
      },
    );
    // .expect(HttpStatus.OK);

    expect(response.body).toEqual({});
  });
});

function addPrefix(path: string): string {
  return `/tm/v1.0${path}`;
}
