import { Module } from '@nestjs/common';
import { DataAccessService } from './data-access.service';
import { DataAccessServiceMock } from './data-access.service.mock';
import { OfferingService } from '../offering/offering.service';
import { CommonUtils } from '../../utils/common.utils';
import { AddressValidatorService } from '../../utils/address-validator-service';
import { LoggerInterceptor } from '../../interceptors';

@Module({
  providers: [
    DataAccessService,
    DataAccessServiceMock,
    OfferingService,
    CommonUtils,
    AddressValidatorService,
    LoggerInterceptor,
  ],
  exports: [DataAccessService],
})
export class DataAccessSharedModule {}
