import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import {
  IsNotEmpty,
  IsNumberString,
  MaxLength,
  IsOptional,
  IsEthereumAddress,
} from 'class-validator';

export class GetTradingAccount {
  @ApiPropertyOptional({ description: 'Token symbol to get balance: FDE' })
  @IsOptional()
  token = 'FDE';
}

export class MintOrBurnPaymentTokenDto {
  @ApiProperty({
    description:
      'Ethereum address of the trading account to mint or burn tokens',
  })
  @IsNotEmpty()
  @IsEthereumAddress()
  tradingAccount: string;

  @ApiProperty({
    description:
      'Amount of payment tokens (FDE) to mint or burn: number string, max length 20',
  })
  @IsNotEmpty()
  @IsNumberString()
  @MaxLength(70)
  amount: string;
}

export class GetContractABIByNameDto {
  @ApiProperty({ description: 'Contract address' })
  @IsNotEmpty()
  contractName: string;
}
export class GetDiamondsInfoByNameDto {
  @ApiProperty({
    description:
      'The name of the Diamond contract (e.g., TradingManagement, Bourse, Governance).',
  })
  @IsNotEmpty()
  diamondName: string;
}
