import { Test, TestingModule } from '@nestjs/testing';
import { GovernanceService } from './governance.service';
import { GovernanceSharedModule } from './governance.module';
import { INestApplication } from '@nestjs/common';
import { AddressValidatorService, CommonUtils } from '../../utils';

describe('GovernanceService (e2e)', () => {
  let app: INestApplication;

  beforeAll(async () => {
    const moduleFixture: TestingModule = await Test.createTestingModule({
      imports: [GovernanceSharedModule],
      providers: [GovernanceService, CommonUtils, AddressValidatorService],
    }).compile();

    app = moduleFixture.createNestApplication();
    await app.init();
  });

  afterAll(async () => {
    await app.close();
  });

  it('Service is successfully constructed!', async () => {
    expect(app).toBeDefined();
  });
});
