import { Logger, Module, OnModuleInit } from '@nestjs/common';
import { InitializerService } from './initializer.service';
import { CommonUtils } from '../../utils/common.utils';
import { LoggerInterceptor } from '../../interceptors';
import { AddressValidatorService } from '../../utils/address-validator-service';

@Module({
  providers: [
    InitializerService,
    CommonUtils,
    AddressValidatorService,
    LoggerInterceptor,
  ],
})
export class InitializerModule implements OnModuleInit {
  private initialized = false;
  private logger = new Logger(InitializerModule.name);
  constructor(private readonly initializerService: InitializerService) {}

  async onModuleInit() {
    await this.initializeAsync();
  }

  private async initializeAsync() {
    // Simulate async initialization (e.g., DB connection, external services)
    setTimeout(() => {
      this.logger.log('Starting Initilizer Module Initialization');
      this.initializerService
        .initContracts()
        .then(() => {
          this.logger.log('--------------------------------------------------');
          this.logger.log(
            'Initial settings done! You can now use the service.',
          );
          this.initialized = true;
        })
        .catch((error) => {
          this.logger.error(`Initialization failed`, error);
        });
    }, 1);
  }

  isInitialized = () => {
    return this.initialized;
  };
}
