import { Module } from '@nestjs/common';
import { OfferingService } from './offering.service';
import { OfferingServiceMock } from './offering.service.mock';
import { CommonUtils } from '../../utils/common.utils';
import { AddressValidatorService } from '../../utils/address-validator-service';
import { LoggerInterceptor } from '../../interceptors';

@Module({
  providers: [
    OfferingService,
    OfferingServiceMock,
    CommonUtils,
    AddressValidatorService,
    LoggerInterceptor,
  ],
  exports: [OfferingService],
})
export class OfferingSharedModule {}
