import { Test, TestingModule } from '@nestjs/testing';
import { OfferingService } from './offering.service';
import { OfferingSharedModule } from './offering.module';
import { CommonUtils } from '../../utils/common.utils';
import { AddressValidatorService } from '../../utils/address-validator-service';
import { INestApplication } from '@nestjs/common';

describe('OfferingService (e2e)', () => {
  let app: INestApplication;

  beforeAll(async () => {
    const moduleFixture: TestingModule = await Test.createTestingModule({
      imports: [OfferingSharedModule],
      providers: [OfferingService, CommonUtils, AddressValidatorService],
    }).compile();

    app = moduleFixture.createNestApplication();
    await app.init();
  });

  afterAll(async () => {
    await app.close();
  });

  it('Service is successfully constructed!', async () => {
    expect(app).toBeDefined();
  });
});
