import { Module } from '@nestjs/common';
import { PaymentService } from './payment.service';
import { PaymentServiceMock } from './payment.service.mock';
import { CommonUtils } from '../../utils/common.utils';
import { AddressValidatorService } from '../../utils/address-validator-service';
import { LoggerInterceptor } from '../../interceptors';

@Module({
  providers: [
    PaymentService,
    PaymentServiceMock,
    CommonUtils,
    AddressValidatorService,
    LoggerInterceptor,
  ],
  exports: [PaymentService],
})
export class PaymentSharedModule {}
