import { Optional } from '@nestjs/common';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import {
  IsEnum,
  IsEthereumAddress,
  IsNotEmpty,
  IsOptional,
} from 'class-validator';
import { TokenType } from '../../data-access/data-access-dto/data-access.dto';

export class GetPurchaseTokensDto {
  @ApiPropertyOptional({
    description: 'Ethereum address of the user to get purchased tokens for',
    example: '0x1234567890abcdef1234567890abcdef12345678',
    required: false,
  })
  @Optional()
  @IsEthereumAddress()
  userAddress: string;
}

export class PurchasedOffersAndOwnerTokensDto {
  @ApiProperty({
    type: 'string',
    description: 'User ethereum address',
  })
  @IsNotEmpty()
  @IsEthereumAddress()
  userAddress: string;

  @ApiProperty({
    type: 'string',
    description: 'Token type: PAYU, PAYG, SUB',
  })
  @IsOptional()
  @IsEnum(TokenType)
  tokenType?: TokenType;
}
